/* NEWDJPEG.C from original djpeg.c - changed from a main program to  a function call 
 *            ... that allows input of raw jpeg data and outputs a bitmap file in memory.
 *            The comments below are no longer applicable.  The library was kludged in a day to 
 *            use memory pointers instead of file i/o.  Only 3 files were touched,
 *            jinclude.h, jdatasrc.c, and wrbmp.c.  This was ment to be used for one explicit demo app 
 *            and nothing else. It is worse than a kludge. a.s.
 *            
 * djpeg.c
 *
 * Copyright (C) 1991-1997, Thomas G. Lane.
 * This file is part of the Independent JPEG Group's software.
 * For conditions of distribution and use, see the accompanying README file.
 *
 * This file contains a command-line user interface for the JPEG decompressor.
 * It should work on any system with Unix- or MS-DOS-style command lines.
 *
 * Two different command line styles are permitted, depending on the
 * compile-time switch TWO_FILE_COMMANDLINE:
 *	djpeg [options]  inputfile outputfile
 *	djpeg [options]  [inputfile]
 * In the second style, output is always to standard output, which you'd
 * normally redirect to a file or pipe to some other program.  Input is
 * either from a named file or from standard input (typically redirected).
 * The second style is convenient on Unix but is unhelpful on systems that
 * don't support pipes.  Also, you MUST use the first style if your system
 * doesn't do binary I/O to stdin/stdout.
 * To simplify script writing, the "-outfile" switch is provided.  The syntax
 *	djpeg [options]  -outfile outputfile  inputfile
 * works regardless of which command line style is used.
 */
#include "windows.h"
#include "memdjpeg.h"

#include "cdjpeg.h"		/* Common decls for cjpeg/djpeg applications */
#include "jversion.h"		/* for version message */


/* Create the add-on message string table. */

#define JMESSAGE(code,string)	string ,

static const char * const cdjpeg_message_table[] = {
#include "cderror.h"
  NULL
};


/*
 * This list defines the known output image formats
 * (not all of which need be supported by a given version).
 * You can change the default output format by defining DEFAULT_FMT;
 * indeed, you had better do so if you undefine PPM_SUPPORTED.
 */

typedef enum {
	FMT_BMP,		/* BMP format (Windows flavor) */
	FMT_GIF,		/* GIF format */
	FMT_OS2,		/* BMP format (OS/2 flavor) */
	FMT_PPM,		/* PPM/PGM (PBMPLUS formats) */
	FMT_RLE,		/* RLE format */
	FMT_TARGA,		/* Targa format */
	FMT_TIFF		/* TIFF format */
} IMAGE_FORMATS;

#ifndef DEFAULT_FMT		/* so can override from CFLAGS in Makefile */
#define DEFAULT_FMT	FMT_BMP
#endif

static IMAGE_FORMATS requested_fmt;


/*
 * Argument-parsing code was removed
 * The switch parser is designed to be useful with DOS-style command line
 * syntax, ie, intermixed switches and file names, where only the switches
 * to the left of a given file name affect processing of that file.
 * The main program in this file doesn't actually use this capability...
 */


static const char * progname;	/* program name for error messages */


/*
 * The main program.
 */


static void myinitcinfo(struct jpeg_decompress_struct *cinfo)
{
         cinfo->err->trace_level = 0;
      requested_fmt = FMT_BMP;
      //cinfo->desired_number_of_colors = 256;
      cinfo->quantize_colors = TRUE;



      /* Select recommended processing options for quick-and-dirty output. */
      cinfo->two_pass_quantize = FALSE;
      cinfo->dither_mode = JDITHER_ORDERED;
      cinfo->quantize_colors = 0;
   	cinfo->desired_number_of_colors = 216;
      cinfo->dct_method = JDCT_FASTEST;
      cinfo->do_fancy_upsampling = FALSE;

      cinfo->out_color_space = JCS_GRAYSCALE;
   

      /* Suppress fancy upsampling */
      cinfo->do_fancy_upsampling = FALSE;


      /* Use fast one-pass quantization. */
      cinfo->two_pass_quantize = FALSE;


}   

size_t decodeJFIF( unsigned char * lpJFIF, size_t nJFIFLen, HGLOBAL *phDIB )
{
  struct jpeg_decompress_struct cinfo;
  struct jpeg_error_mgr jerr;

  djpeg_dest_ptr dest_mgr = NULL;
  JDIMENSION num_scanlines;




  memset(&cinfo, 0, sizeof(cinfo));

   /* On Mac, fetch a command line. */

  progname = "djpeg";		/* in case C library doesn't provide it */

  /* Initialize the JPEG decompression object with default error handling. */
  cinfo.err = jpeg_std_error(&jerr);
  jpeg_create_decompress(&cinfo);
  /* Add some application-specific error messages (from cderror.h) */
  jerr.addon_message_table = cdjpeg_message_table;
  jerr.first_addon_message = JMSG_FIRSTADDONCODE;
  jerr.last_addon_message = JMSG_LASTADDONCODE;

  /* Insert custom marker processor for COM and APP12.
   * APP12 is used by some digital camera makers for textual info,
   * so we provide the ability to display it as text.
   * If you like, additional APPn marker types can be selected for display,
   * but don't try to override APP0 or APP14 this way (see libjpeg.doc).
   */
//  jpeg_set_marker_processor(&cinfo, JPEG_COM, print_text_marker);
//  jpeg_set_marker_processor(&cinfo, JPEG_APP0+12, print_text_marker);

  /* Now safe to enable signal catcher. */
#ifdef NEED_SIGNAL_CATCHER
  enable_signal_catcher((j_common_ptr) &cinfo);
#endif
	myinitcinfo(&cinfo);
  /* Scan command line to find file names. */
  /* It is convenient to use just one switch-parsing routine, but the switch
   * values read here are ignored; we will rescan the switches after opening
   * the input file.
   * (Exception: tracing level set here controls verbosity for COM markers
   * found during jpeg_read_header...)
   */

  myinit_input_stream(nJFIFLen);


#ifdef PROGRESS_REPORT
  start_progress_monitor((j_common_ptr) &cinfo, &progress);
#endif

  /* Specify data source for decompression */
  //jpeg_stdio_src(&cinfo, input_file);
  jpeg_stdio_src(&cinfo, (FILE *)lpJFIF);  /* I know this cast is worse than a kludge but we only have a day a.s. */

  /* Read file header, set default decompression parameters */
  (void) jpeg_read_header(&cinfo, TRUE);

  /* Adjust default decompression parameters by re-parsing the options */
  //file_index = parse_switches(&cinfo, argc, argv, 0, TRUE);

  /* Initialize the output module now to let it override any crucial
   * option settings (for instance, GIF wants to force color quantization).
   */

  dest_mgr = jinit_write_bmp(&cinfo, FALSE);
  //dest_mgr->output_file = output_file;
 // dest_mgr->output_file = (FILE *)pOut;
   dest_mgr->output_file = (FILE *)NULL;

  /* Start decompressor */
  (void) jpeg_start_decompress(&cinfo);

  /* Write output file header */
  (*dest_mgr->start_output) (&cinfo, dest_mgr);

  /* Process data */
  while (cinfo.output_scanline < cinfo.output_height) 
  {
    num_scanlines = jpeg_read_scanlines(&cinfo, dest_mgr->buffer,
					dest_mgr->buffer_height);
    (*dest_mgr->put_pixel_rows) (&cinfo, dest_mgr, num_scanlines);
  }

#ifdef PROGRESS_REPORT
  /* Hack: count final pass as done in case finish_output does an extra pass.
   * The library won't have updated completed_passes.
   */
  progress.pub.completed_passes = progress.pub.total_passes;
#endif

  /* Finish decompression and release memory.
   * I must do it in this order because output module has allocated memory
   * of lifespan JPOOL_IMAGE; it needs to finish before releasing memory.
   */
  (*dest_mgr->finish_output) (&cinfo, dest_mgr);
  *phDIB = dest_mgr->output_file;
  (void) jpeg_finish_decompress(&cinfo);
  
  jpeg_destroy_decompress(&cinfo);

  

#ifdef PROGRESS_REPORT
  end_progress_monitor((j_common_ptr) &cinfo);
#endif

  return myGetOutputBytesWritten();
}

void freeJFIFbmp(HGLOBAL hDIB)
{
	if(hDIB)
		GlobalFree(hDIB);
}



